/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchLinuxVersion;
import oracle.sysman.oip.oipc.oipch.OipchNumKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchRangeKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchStrKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchVerKernelProperty;

public class OipchLinuxKernelReader {
    private static String LINUX_TEMP_FILE = "tmpFileKernelParms.txt";
    private static String LINUX_UNAME = "/bin/uname -a";

    private OipchLinuxKernelReader() {
    }

    public static OipchKernelProperty[] getKernelParameters() throws IOException {
        ArrayList<OipchKernelProperty> store = new ArrayList<OipchKernelProperty>();
        String[] lines = OipchLinuxKernelReader.runLocalUnixCommand(LINUX_UNAME);
        String[] uname_bits = OipchLinuxKernelReader.splitString(lines[0], " ");
        String sValue = uname_bits[2];
        try {
            OipchLinuxVersion oVer = new OipchLinuxVersion(sValue);
            OipchVerKernelProperty oVerProp = new OipchVerKernelProperty("VERSION", oVer);
            store.add(oVerProp);
        }
        catch (OipchIncorrectVersionFormatException e) {
            e.printStackTrace();
        }
        Map allparams = OipchLinuxKernelReader.getLinuxSystemParameters();
        Iterator iter = allparams.keySet().iterator();
        while (iter.hasNext()) {
            String sKey = (String)iter.next();
            String sVal = (String)allparams.get(sKey);
            OipchKernelProperty oProp = null;
            try {
                oProp = new OipchNumKernelProperty(sKey, new Long(sVal));
            }
            catch (NumberFormatException nfe) {
                oProp = new OipchStrKernelProperty(sKey, sVal);
            }
            store.add(oProp);
        }
        Map rangeparams = OipchLinuxKernelReader.getLinuxSystemRangeParameters();
        Iterator rangeIter = rangeparams.keySet().iterator();
        while (rangeIter.hasNext()) {
            String sKey = (String)rangeIter.next();
            OipchKernelProperty oProp = (OipchKernelProperty)rangeparams.get(sKey);
            store.add(oProp);
        }
        OipchKernelProperty[] retVal = new OipchKernelProperty[store.size()];
        retVal = store.toArray(retVal);
        return retVal;
    }

    private static Map getLinuxSystemRangeParameters() throws IOException {
        String linux_ip_local_port_range_command = "/bin/cat /proc/sys/net/ipv4/ip_local_port_range";
        String linux_ip_local_port_range = "ip_local_port_range";
        String[] ip_local_port_range_lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_ip_local_port_range_command);
        String[] ip_local_port_range_tokens = OipchLinuxKernelReader.splitString(ip_local_port_range_lines[0], "\t");
        HashMap<String, OipchRangeKernelProperty> store = new HashMap<String, OipchRangeKernelProperty>();
        OipchKernelProperty oRangeProp = null;
        if (ip_local_port_range_tokens.length == 2) {
            try {
                Long oLower = new Long(ip_local_port_range_tokens[0]);
                Long oUpper = new Long(ip_local_port_range_tokens[1]);
                oRangeProp = new OipchRangeKernelProperty(linux_ip_local_port_range, oLower, oUpper);
            }
            catch (NumberFormatException oNfe) {
                oRangeProp = new OipchStrKernelProperty(linux_ip_local_port_range, ip_local_port_range_tokens[0] + " - " + ip_local_port_range_tokens[1]);
            }
        }
        store.put(linux_ip_local_port_range, (OipchRangeKernelProperty)oRangeProp);
        return store;
    }

    private static String[] splitString(String Source, String separator) {
        StringTokenizer strtok = new StringTokenizer(Source, separator);
        String[] retArr = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            retArr[i] = strtok.nextToken();
            ++i;
        }
        return retArr;
    }

    private static Map getLinuxSystemParameters() throws IOException {
        int i;
        String linux_sem_command = "/bin/cat /proc/sys/kernel/sem";
        String linux_shmmax_command = "/bin/cat /proc/sys/kernel/shmmax";
        String linux_shmmni_command = "/bin/cat /proc/sys/kernel/shmmni";
        String linux_shmall_command = "/bin/cat /proc/sys/kernel/shmall";
        String linux_shm_misc_command = "/usr/bin/ipcs -lm";
        String linux_sem_misc_command = "/usr/bin/ipcs -ls";
        String linux_filemax_command = "/bin/cat /proc/sys/fs/file-max";
        String linux_msgmni_command = "/bin/cat /proc/sys/kernel/msgmni";
        String linux_msgmax_command = "/bin/cat /proc/sys/kernel/msgmax";
        String linux_msgmnb_command = "/bin/cat /proc/sys/kernel/msgmnb";
        String linux_softnofiles_command = "/bin/sh -c \"ulimit -Sn\"";
        String linux_hardnofiles_command = "/bin/sh -c \"ulimit -Hn\"";
        String linux_rmem_default_command = "/bin/cat /proc/sys/net/core/rmem_default";
        String linux_rmem_max_command = "/bin/cat /proc/sys/net/core/rmem_max";
        String linux_wmem_default_command = "/bin/cat /proc/sys/net/core/wmem_default";
        String linux_wmem_max_command = "/bin/cat /proc/sys/net/core/wmem_max";
        String linux_sysrq_command = "/bin/cat /proc/sys/kernel/sysrq";
        String linux_aiomaxnr_command = "/bin/cat /proc/sys/fs/aio-max-nr";
        String linux_strsemmsl = "semmsl";
        String linux_strsemmns = "semmns";
        String linux_strsemopm = "semopm";
        String linux_strsemmni = "semmni";
        String linux_strsemvmx = "semvmx";
        String linux_strshmmax = "shmmax";
        String linux_strshmmni = "shmmni";
        String linux_strshmall = "shmall";
        String linux_strshmmin = "shmmin";
        String linux_strshmseg = "shmseg";
        String linux_strmsgmni = "msgmni";
        String linux_strmsgmnb = "msgmnb";
        String linux_strmsgmax = "msgmax";
        String linux_sysrq = "sysrq";
        String linux_aiomxnr = "aio-max-nr";
        String linux_strfilemax = "file-max";
        String linux_str_softnofiles = "softnofiles";
        String linux_str_hardnofiles = "hardnofiles";
        String linux_wmem_default = "wmem_default";
        String linux_wmem_max = "wmem_max";
        String linux_rmem_default = "rmem_default";
        String linux_rmem_max = "rmem_max";
        String linux_sem_max_val_statement = "semaphore max value";
        String linux_min_seg_statement = "min seg size";
        String linux_max_seg_statement = "max number of segments";
        HashMap<String, String> store = new HashMap<String, String>();
        String[] lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_sem_command);
        String[] tokens = OipchLinuxKernelReader.splitString(lines[0], "\t");
        if (tokens.length == 4) {
            store.put(linux_strsemmsl, tokens[0].trim());
            store.put(linux_strsemmns, tokens[1].trim());
            store.put(linux_strsemopm, tokens[2].trim());
            store.put(linux_strsemmni, tokens[3].trim());
        }
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_sem_misc_command);
        for (i = 0; i < lines.length; ++i) {
            if (lines[i].indexOf(61) == -1 || (tokens = OipchLinuxKernelReader.splitString(lines[i], "="))[0].indexOf(linux_sem_max_val_statement) == -1) continue;
            store.put(linux_strsemvmx, tokens[1].trim());
            break;
        }
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_shmmax_command);
        store.put(linux_strshmmax, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_shmmni_command);
        store.put(linux_strshmmni, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_shmall_command);
        store.put(linux_strshmall, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_shm_misc_command);
        for (i = 0; i < lines.length; ++i) {
            if (lines[i].indexOf(61) == -1) continue;
            tokens = OipchLinuxKernelReader.splitString(lines[i], "=");
            if (tokens[0].indexOf(linux_min_seg_statement) != -1) {
                store.put(linux_strshmmin, tokens[1].trim());
                continue;
            }
            if (tokens[0].indexOf(linux_max_seg_statement) == -1) continue;
            store.put(linux_strshmseg, tokens[1].trim());
        }
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_filemax_command);
        store.put(linux_strfilemax, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_msgmni_command);
        store.put(linux_strmsgmni, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_msgmnb_command);
        store.put(linux_strmsgmnb, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_msgmax_command);
        store.put(linux_strmsgmax, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_wmem_default_command);
        store.put(linux_wmem_default, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_wmem_max_command);
        store.put(linux_wmem_max, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_rmem_default_command);
        store.put(linux_rmem_default, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_rmem_max_command);
        store.put(linux_rmem_max, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_sysrq_command);
        store.put(linux_sysrq, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_aiomaxnr_command);
        store.put(linux_aiomxnr, lines[0].trim());
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_softnofiles_command);
        try {
            int temp_int = Integer.parseInt(lines[0].trim());
            store.put(linux_str_softnofiles, lines[0].trim());
        }
        catch (NumberFormatException ne) {
            store.put(linux_str_softnofiles, String.valueOf(Integer.MAX_VALUE));
        }
        lines = OipchLinuxKernelReader.runLocalUnixCommand(linux_hardnofiles_command);
        try {
            int temp_int = Integer.parseInt(lines[0].trim());
            store.put(linux_str_hardnofiles, lines[0].trim());
        }
        catch (NumberFormatException ne) {
            store.put(linux_str_hardnofiles, String.valueOf(Integer.MAX_VALUE));
        }
        return store;
    }

    private static String[] runLocalUnixCommand(String command) throws IOException {
        String currentLine;
        String sFile = OiixPathOps.concatPath((String)OipchLinuxKernelReader.getScratchPath(), (String)LINUX_TEMP_FILE);
        File oFile = new File(sFile);
        String sParent = OiixPathOps.getParentDir((String)sFile);
        OiixFileOps.mkdirs((File)new File(sParent));
        String sCommand = command + ">" + sFile;
        int result = 0;
        try {
            result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
        }
        File oTmpFile = new File(sFile);
        if (!oTmpFile.exists()) {
            return new String[]{""};
        }
        ArrayList<String> store = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(sFile));
        while ((currentLine = reader.readLine()) != null) {
            currentLine.trim();
            store.add(currentLine);
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return OiixVectorOps.list2StrArr(store);
    }

    private static String getScratchPath() {
        return System.getProperty("oracle.installer.scratchPath", "");
    }
}

